/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.tileentity;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.block.BlockSummoningPedestal;
import com.lycanitesmobs.core.container.ContainerBase;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityPortal;
import com.lycanitesmobs.core.gui.GUISummoningPedestal;
import com.lycanitesmobs.core.network.MessageSummoningPedestalStats;
import com.lycanitesmobs.core.network.MessageSummoningPedestalSummonSet;
import com.lycanitesmobs.core.pets.SummonSet;
import com.lycanitesmobs.core.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TileEntitySummoningPedestal
extends TileEntityBase {
    public long updateTick = 0L;
    public EntityPortal summoningPortal;
    public UUID ownerUUID;
    public String ownerName = "";
    public SummonSet summonSet;
    public int summonAmount = 1;
    public int capacityCharge = 100;
    public int capacity = 0;
    public int capacityMax = this.capacityCharge * 10;
    public int summonProgress = 0;
    public int summonProgressMax = 180;
    public List<EntityCreatureBase> minions = new ArrayList<EntityCreatureBase>();
    protected String[] loadMinionIDs;
    protected boolean blockStateSet = false;

    @Override
    public void onRemove() {
        if (this.summoningPortal != null && !this.summoningPortal.field_70128_L) {
            this.summoningPortal.func_70106_y();
        }
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.summonProgress >= this.summonProgressMax) {
                this.summonProgress = 0;
            } else if (this.summonProgress > 0) {
                ++this.summonProgress;
            }
            return;
        }
        if (this.loadMinionIDs != null) {
            int range = 20;
            List nearbyEntities = this.field_145850_b.func_72872_a(EntityCreatureBase.class, new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - range), (double)(this.func_174877_v().func_177956_o() - range), (double)(this.func_174877_v().func_177952_p() - range), (double)(this.func_174877_v().func_177958_n() + range), (double)(this.func_174877_v().func_177956_o() + range), (double)(this.func_174877_v().func_177952_p() + range)));
            block2: for (EntityCreatureBase possibleEntity : nearbyEntities) {
                for (String loadMinionID : this.loadMinionIDs) {
                    UUID uuid = null;
                    try {
                        uuid = UUID.fromString(loadMinionID);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!possibleEntity.func_110124_au().equals(uuid)) continue;
                    this.minions.add(possibleEntity);
                    continue block2;
                }
            }
            this.loadMinionIDs = null;
        }
        if (this.summonSet == null || this.summonSet.getMobInfo() == null) {
            return;
        }
        if (this.summonSet.getFollowing()) {
            this.summonSet.following = false;
        }
        if (this.summoningPortal == null || this.summoningPortal.field_70128_L) {
            this.summoningPortal = new EntityPortal(this.field_145850_b, this);
            this.summoningPortal.setProjectileScale(8.0f);
            this.field_145850_b.func_72838_d((Entity)this.summoningPortal);
        }
        if (this.updateTick % 100L == 0L) {
            this.capacity = 0;
            for (EntityCreatureBase minion : this.minions.toArray(new EntityCreatureBase[this.minions.size()])) {
                if (minion == null || minion.field_70128_L) {
                    this.minions.remove((Object)minion);
                    continue;
                }
                this.capacity += minion.mobInfo.summonCost * this.capacityCharge;
            }
        }
        if (this.capacity + this.summonSet.getMobInfo().summonCost > this.capacityMax) {
            this.summonProgress = 0;
        } else if (this.summonProgress++ >= this.summonProgressMax) {
            this.summoningPortal.summonCreatures();
            this.summonProgress = 0;
            this.capacity = Math.min(this.capacity + this.capacityCharge * this.summonSet.getMobInfo().summonCost, this.capacityMax);
        }
        if (!this.blockStateSet) {
            if (!"".equals(this.getOwnerName())) {
                BlockSummoningPedestal.setState(BlockSummoningPedestal.EnumSummoningPedestal.PLAYER, this.func_145831_w(), this.func_174877_v());
            } else {
                BlockSummoningPedestal.setState(BlockSummoningPedestal.EnumSummoningPedestal.NONE, this.func_145831_w(), this.func_174877_v());
            }
            this.blockStateSet = true;
        }
        if (this.updateTick % 20L == 0L) {
            LycanitesMobs.packetHandler.sendToAllAround(new MessageSummoningPedestalStats(this.capacity, this.summonProgress, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 5.0));
        }
        ++this.updateTick;
    }

    public void setOwner(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.ownerUUID = entity.func_110124_au();
            this.ownerName = entity.func_70005_c_();
        }
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public EntityPlayer getPlayer() {
        if (this.ownerUUID == null) {
            return null;
        }
        return this.field_145850_b.func_152378_a(this.ownerUUID);
    }

    public Class getSummonClass() {
        return this.summonSet.getCreatureClass();
    }

    public void setSummonSet(SummonSet summonSet) {
        this.summonSet = new SummonSet(null);
        this.summonSet.setSummonType(summonSet.summonType);
        this.summonSet.sitting = summonSet.getSitting();
        this.summonSet.following = false;
        this.summonSet.passive = summonSet.getPassive();
        this.summonSet.aggressive = summonSet.getAggressive();
        this.summonSet.pvp = summonSet.getPVP();
    }

    public void applyMinionBehaviour(EntityCreatureTameable minion) {
        if (this.summonSet != null) {
            this.summonSet.applyBehaviour(minion);
        }
        this.minions.add(minion);
        minion.setHome(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 20.0f);
    }

    @Override
    public boolean func_145842_c(int eventID, int eventArg) {
        return false;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        if (this.summonSet != null) {
            NBTTagCompound summonSetNBT = new NBTTagCompound();
            this.summonSet.writeToNBT(summonSetNBT);
            syncData.func_74782_a("SummonSet", (NBTBase)summonSetNBT);
        }
        if (!this.field_145850_b.field_72995_K && this.getOwnerUUID() != null && this.getOwnerName() != null) {
            syncData.func_74778_a("OwnerUUID", this.getOwnerUUID().toString());
            syncData.func_74778_a("OwnerName", this.getOwnerName());
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, syncData);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        NBTTagCompound syncData = packet.func_148857_g();
        if (syncData.func_74764_b("OwnerUUID")) {
            this.ownerUUID = UUID.fromString(syncData.func_74779_i("OwnerUUID"));
        }
        if (syncData.func_74764_b("OwnerName")) {
            this.ownerName = syncData.func_74779_i("OwnerName");
        }
        if (syncData.func_74764_b("SummonSet")) {
            SummonSet summonSet = new SummonSet(null);
            summonSet.readFromNBT(syncData.func_74775_l("SummonSet"));
            this.summonSet = summonSet;
        }
    }

    public void sendSummonSetToServer(SummonSet summonSet) {
        LycanitesMobs.packetHandler.sendToServer(new MessageSummoningPedestalSummonSet(summonSet, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        String uuidString;
        super.func_145839_a(nbtTagCompound);
        this.ownerUUID = nbtTagCompound.func_74764_b("OwnerUUID") ? (!"".equals(uuidString = nbtTagCompound.func_74779_i("OwnerUUID")) ? UUID.fromString(uuidString) : null) : null;
        this.ownerName = nbtTagCompound.func_74764_b("OwnerName") ? nbtTagCompound.func_74779_i("OwnerName") : "";
        if (nbtTagCompound.func_74764_b("SummonSet")) {
            NBTTagCompound summonSetNBT = nbtTagCompound.func_74775_l("SummonSet");
            SummonSet summonSet = new SummonSet(null);
            summonSet.readFromNBT(summonSetNBT);
            this.summonSet = summonSet;
        } else {
            this.summonSet = null;
        }
        if (nbtTagCompound.func_74764_b("MinionIDs")) {
            NBTTagList minionIDs = nbtTagCompound.func_150295_c("MinionIDs", 10);
            this.loadMinionIDs = new String[minionIDs.func_74745_c()];
            for (int i = 0; i < minionIDs.func_74745_c(); ++i) {
                NBTTagCompound minionID = minionIDs.func_150305_b(i);
                if (!minionID.func_74764_b("ID")) continue;
                this.loadMinionIDs[i] = minionID.func_74779_i("ID");
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        if (this.ownerUUID == null) {
            nbtTagCompound.func_74778_a("OwnerUUID", "");
        } else {
            nbtTagCompound.func_74778_a("OwnerUUID", this.ownerUUID.toString());
        }
        if (this.summonSet != null) {
            NBTTagCompound summonSetNBT = new NBTTagCompound();
            this.summonSet.writeToNBT(summonSetNBT);
            nbtTagCompound.func_74782_a("SummonSet", (NBTBase)summonSetNBT);
        }
        nbtTagCompound.func_74778_a("OwnerName", this.ownerName);
        if (this.minions.size() > 0) {
            NBTTagList minionIDs = new NBTTagList();
            for (EntityLivingBase entityLivingBase : this.minions) {
                NBTTagCompound minionID = new NBTTagCompound();
                minionID.func_74778_a("ID", entityLivingBase.func_110124_au().toString());
                minionIDs.func_74742_a((NBTBase)minionID);
            }
            nbtTagCompound.func_74782_a("MinionIDs", (NBTBase)minionIDs);
        }
        return nbtTagCompound;
    }

    @Override
    public Object getGUI(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return new GUISummoningPedestal(player, this);
        }
        return new ContainerBase(this);
    }
}

